#version 330
#extension GL_EXT_gpu_shader4 : enable
// Mandelbrot texture orbit trapMod01.fsh  by matistjati

//https://www.shadertoy.com/view/WljGWV
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const vec2 origin = vec2(-.92885, -0.3119);
//const vec2 origin = vec2(-.5, 0.);

vec3 render(vec2 pos)
{
	vec2 z = pos;
    vec2 trap = vec2(1000.);
    const float maxIter = 1024.;
    const float escapeRadius = 8.;
    float iP;
    vec3 col = vec3(0.);
    for (float i = 0.;i < maxIter; i++) 
    {
        if (dot(z,z)> escapeRadius) break;
        z = mat2(z, -z.y, z.x) * z + pos; // Z -> Z^2+C
        trap = min(trap, vec2(length(z), length( fract(z)-.5)));


        iP++;
     }
    

    //return vec3(iP*z.x, iP*length(z), iP*z.y);
    //return (iP == 1.) ? vec3(0.) : texture2D(iChannel0, z/escapeRadius, 0.0).xyz;
    return (iP == maxIter) ? texture2D(iChannel0, abs(z)).xyz : texture2D(iChannel0, trap).xyz;
}


void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float tz = 0.5-0.5*cos(0.225*iTime);
    float zoom = pow( 0.5, 13.0*tz );	
// Normalized pixel coordinates (from 0 to 1)
	vec2 uv = (2. * gl_FragCoord.xy - iResolution.xy ) / iResolution.y;
    
    vec2 c = origin + uv*zoom;
    // Time varying pixel color
    //uv += iMouse.xy/iResolution.xy*4.-1.;

    vec3 col = (render(c));
    gl_FragColor = vec4(col,1.0);
}
